﻿#Import-Module activedirectory

$users = Import-Csv "C:\Temp\adusers.csv"

ForEach ($user in $users) {

$u = $user.SamAccountName

if (Get-ADUser -Filter {SamAccountName -eq $u}) {

Write-Warning "Das Konto mit dem Namen $U existiert bereits." }
	
else {

$upn = $user.SamAccountName + "@ndsedv.de"

New-ADUser `
-Name $user.DisplayName`
-DisplayName $user.DisplayName `
-GivenName $user.FirstName `
-Surname $user.LastName `
-OfficePhone $user.Phone `
-Department $user.Department `
-Title $user.Title `
-Description $user.Description `
-UserPrincipalName $upn `
-SamAccountName $user.samAccountName `
-Path $user.OU `
-Office $user.Office `
-City $user.City `
-StreetAddress $user.Street `
-PostalCode $user.PostalCode `
-State $user.State `
-Country $user.Country `
-Company $user.Company `
-AccountPassword (ConvertTo-SecureString $user.Password -AsPlainText -force) -Enabled $true

Write-Host "Der Benutzer "$user.DisplayName" wurde angelegt" -ForegroundColor Cyan

$Groups = @("AD First Level","P - Technical Users Deny Log on")

ForEach ($Group in $Groups) {

Add-AdGroupMember -Identity $Group -Members $user.SamAccountName

Write-Host "Der Benutzer "$user.DisplayName" wurde der Gruppe $Group hinzugefügt" -ForegroundColor Green

}}}